//
// Copyright 2023 Ettus Research, a National Instruments Brand
//
// SPDX-License-Identifier: LGPL-3.0-or-later
//
// Module: rfnoc_image_core (for e31x)
//
// Description:
//
//   The RFNoC Image Core contains the Verilog description of the RFNoC design
//   to be loaded onto the FPGA.
//
//   This file was automatically generated by the RFNoC image builder tool.
//   Re-running that tool will overwrite this file!
//
// Source: e310_rfnoc_image_core.yml
//

`default_nettype none


module rfnoc_image_core #(
  parameter [31:0] CHDR_W     = 64,
  parameter [31:0] PORT_W     = 64,
  parameter [31:0] DMA_W      = 64,
  parameter        MTU        = 10,
  parameter [15:0] PROTOVER   = {8'd1, 8'd0},
  parameter        RADIO_NIPC = 1
) (
  // Clocks
  input  wire         chdr_aclk,
  input  wire         ctrl_aclk,
  input  wire         core_arst,
  input  wire         radio_clk,
  input  wire         dram_clk,
  // Basic
  input  wire [  15:0] device_id,

  // IO ports /////////////////////////

  // ctrlport
  output wire [   0:0] m_ctrlport_req_wr,
  output wire [   0:0] m_ctrlport_req_rd,
  output wire [  19:0] m_ctrlport_req_addr,
  output wire [  31:0] m_ctrlport_req_data,
  output wire [   3:0] m_ctrlport_req_byte_en,
  output wire [   0:0] m_ctrlport_req_has_time,
  output wire [  63:0] m_ctrlport_req_time,
  input  wire [   0:0] m_ctrlport_resp_ack,
  input  wire [   1:0] m_ctrlport_resp_status,
  input  wire [  31:0] m_ctrlport_resp_data,
  // time
  input  wire [  63:0] radio_time,
  // radio
  input  wire [ 255:0] radio_rx_data,
  input  wire [   7:0] radio_rx_stb,
  output wire [   7:0] radio_rx_running,
  output wire [ 255:0] radio_tx_data,
  input  wire [   7:0] radio_tx_stb,
  output wire [   7:0] radio_tx_running,
  // dram
  input  wire [   0:0] axi_rst,
  output wire [   3:0] m_axi_awid,
  output wire [ 191:0] m_axi_awaddr,
  output wire [  31:0] m_axi_awlen,
  output wire [  11:0] m_axi_awsize,
  output wire [   7:0] m_axi_awburst,
  output wire [   3:0] m_axi_awlock,
  output wire [  15:0] m_axi_awcache,
  output wire [  11:0] m_axi_awprot,
  output wire [  15:0] m_axi_awqos,
  output wire [  15:0] m_axi_awregion,
  output wire [   3:0] m_axi_awuser,
  output wire [   3:0] m_axi_awvalid,
  input  wire [   3:0] m_axi_awready,
  output wire [2047:0] m_axi_wdata,
  output wire [ 255:0] m_axi_wstrb,
  output wire [   3:0] m_axi_wlast,
  output wire [   3:0] m_axi_wuser,
  output wire [   3:0] m_axi_wvalid,
  input  wire [   3:0] m_axi_wready,
  input  wire [   3:0] m_axi_bid,
  input  wire [   7:0] m_axi_bresp,
  input  wire [   3:0] m_axi_buser,
  input  wire [   3:0] m_axi_bvalid,
  output wire [   3:0] m_axi_bready,
  output wire [   3:0] m_axi_arid,
  output wire [ 191:0] m_axi_araddr,
  output wire [  31:0] m_axi_arlen,
  output wire [  11:0] m_axi_arsize,
  output wire [   7:0] m_axi_arburst,
  output wire [   3:0] m_axi_arlock,
  output wire [  15:0] m_axi_arcache,
  output wire [  11:0] m_axi_arprot,
  output wire [  15:0] m_axi_arqos,
  output wire [  15:0] m_axi_arregion,
  output wire [   3:0] m_axi_aruser,
  output wire [   3:0] m_axi_arvalid,
  input  wire [   3:0] m_axi_arready,
  input  wire [   3:0] m_axi_rid,
  input  wire [2047:0] m_axi_rdata,
  input  wire [   7:0] m_axi_rresp,
  input  wire [   3:0] m_axi_rlast,
  input  wire [   3:0] m_axi_ruser,
  input  wire [   3:0] m_axi_rvalid,
  output wire [   3:0] m_axi_rready,

  // Transport Adapters ///////////////

  // Transport 0 (dma)
  input  wire [PORT_W-1:0] s_dma_tdata,
  input  wire              s_dma_tlast,
  input  wire              s_dma_tvalid,
  output wire              s_dma_tready,
  output wire [PORT_W-1:0] m_dma_tdata,
  output wire              m_dma_tlast,
  output wire              m_dma_tvalid,
  input  wire              m_dma_tready
);

  localparam EDGE_TBL_FILE = `"`RFNOC_EDGE_TBL_FILE`";
  localparam BLOCK_CHDR_W  = 64;
  localparam BYTE_MTU      = MTU + $clog2(CHDR_W/8);
  localparam BLOCK_MTU     = BYTE_MTU - $clog2(BLOCK_CHDR_W/8);
  localparam EP0_W   = 64;
  localparam EP0_MTU = BYTE_MTU - $clog2(EP0_W/8);
  localparam EP1_W   = 64;
  localparam EP1_MTU = BYTE_MTU - $clog2(EP1_W/8);

  wire rfnoc_chdr_clk, rfnoc_chdr_rst;
  wire rfnoc_ctrl_clk, rfnoc_ctrl_rst;


  //---------------------------------------------------------------------------
  // CHDR Crossbar
  //---------------------------------------------------------------------------

  wire [PORT_W-1:0] xb_to_ep0_tdata ;
  wire              xb_to_ep0_tlast ;
  wire              xb_to_ep0_tvalid;
  wire              xb_to_ep0_tready;
  wire [PORT_W-1:0] ep0_to_xb_tdata ;
  wire              ep0_to_xb_tlast ;
  wire              ep0_to_xb_tvalid;
  wire              ep0_to_xb_tready;
  wire [PORT_W-1:0] xb_to_ep1_tdata ;
  wire              xb_to_ep1_tlast ;
  wire              xb_to_ep1_tvalid;
  wire              xb_to_ep1_tready;
  wire [PORT_W-1:0] ep1_to_xb_tdata ;
  wire              ep1_to_xb_tlast ;
  wire              ep1_to_xb_tvalid;
  wire              ep1_to_xb_tready;

  chdr_crossbar_nxn #(
    .PORT_W         (PORT_W),
    .NPORTS         (3),
    .CHDR_WIDTHS    ({EP1_W, EP0_W, DMA_W}),
    .DEFAULT_PORT   (0),
    .ROUTES         ({ 3'b111,
                       3'b111,
                       3'b111 }),
    .BYTE_MTU       (BYTE_MTU),
    .ROUTE_TBL_SIZE (6),
    .MUX_ALLOC      ("ROUND-ROBIN"),
    .OPTIMIZE       ("AREA"),
    .NPORTS_MGMT    (1),
    .EXT_RTCFG_PORT (0),
    .PROTOVER       (PROTOVER)
  ) chdr_crossbar_nxn_i (
    .clk            (rfnoc_chdr_clk),
    .reset          (rfnoc_chdr_rst),
    .device_id      (device_id),
    .s_axis_tdata   ({ep1_to_xb_tdata , ep0_to_xb_tdata , s_dma_tdata }),
    .s_axis_tlast   ({ep1_to_xb_tlast , ep0_to_xb_tlast , s_dma_tlast }),
    .s_axis_tvalid  ({ep1_to_xb_tvalid, ep0_to_xb_tvalid, s_dma_tvalid}),
    .s_axis_tready  ({ep1_to_xb_tready, ep0_to_xb_tready, s_dma_tready}),
    .m_axis_tdata   ({xb_to_ep1_tdata , xb_to_ep0_tdata , m_dma_tdata }),
    .m_axis_tlast   ({xb_to_ep1_tlast , xb_to_ep0_tlast , m_dma_tlast }),
    .m_axis_tvalid  ({xb_to_ep1_tvalid, xb_to_ep0_tvalid, m_dma_tvalid}),
    .m_axis_tready  ({xb_to_ep1_tready, xb_to_ep0_tready, m_dma_tready}),
    .ext_rtcfg_stb  (1'h0),
    .ext_rtcfg_addr (16'h0),
    .ext_rtcfg_data (32'h0),
    .ext_rtcfg_ack  ()
  );


  //---------------------------------------------------------------------------
  // Stream Endpoints
  //---------------------------------------------------------------------------

  // If requested buffer size is 0, use the minimum SRL-based FIFO size.
  // Otherwise, make sure it's at least two MTU-sized packets.
  localparam REQ_BUFF_SIZE_EP0 = 16384;
  localparam INGRESS_BUFF_SIZE_EP0 =
    REQ_BUFF_SIZE_EP0 == 0             ? 5         :
    REQ_BUFF_SIZE_EP0 < 2*(2**EP0_MTU) ? EP0_MTU+1 :
                                         $clog2(REQ_BUFF_SIZE_EP0);

  wire [BLOCK_CHDR_W-1:0] m_ep0_out0_tdata;
  wire                    m_ep0_out0_tlast;
  wire                    m_ep0_out0_tvalid;
  wire                    m_ep0_out0_tready;
  wire [BLOCK_CHDR_W-1:0] s_ep0_in0_tdata;
  wire                    s_ep0_in0_tlast;
  wire                    s_ep0_in0_tvalid;
  wire                    s_ep0_in0_tready;
  wire [            31:0] m_ep0_ctrl_tdata,  s_ep0_ctrl_tdata;
  wire                    m_ep0_ctrl_tlast,  s_ep0_ctrl_tlast;
  wire                    m_ep0_ctrl_tvalid, s_ep0_ctrl_tvalid;
  wire                    m_ep0_ctrl_tready, s_ep0_ctrl_tready;

  chdr_stream_endpoint #(
    .DEVICE_FAMILY      ("7SERIES"),
    .PROTOVER           (PROTOVER),
    .CHDR_W             (EP0_W),
    .BLOCK_CHDR_W       (BLOCK_CHDR_W),
    .AXIS_CTRL_EN       (1),
    .AXIS_DATA_EN       (1),
    .NUM_DATA_I         (1),
    .NUM_DATA_O         (1),
    .INST_NUM           (0),
    .CTRL_XBAR_PORT     (1),
    .INGRESS_BUFF_SIZE  (INGRESS_BUFF_SIZE_EP0),
    .MTU                (EP0_MTU),
    .REPORT_STRM_ERRS   (1)
  ) ep0_i (
    .rfnoc_chdr_clk     (rfnoc_chdr_clk),
    .rfnoc_chdr_rst     (rfnoc_chdr_rst),
    .rfnoc_ctrl_clk     (rfnoc_ctrl_clk),
    .rfnoc_ctrl_rst     (rfnoc_ctrl_rst),
    .device_id          (device_id),
    .s_axis_chdr_tdata  (xb_to_ep0_tdata),
    .s_axis_chdr_tlast  (xb_to_ep0_tlast),
    .s_axis_chdr_tvalid (xb_to_ep0_tvalid),
    .s_axis_chdr_tready (xb_to_ep0_tready),
    .m_axis_chdr_tdata  (ep0_to_xb_tdata),
    .m_axis_chdr_tlast  (ep0_to_xb_tlast),
    .m_axis_chdr_tvalid (ep0_to_xb_tvalid),
    .m_axis_chdr_tready (ep0_to_xb_tready),
    .s_axis_data_tdata  ({s_ep0_in0_tdata}),
    .s_axis_data_tlast  ({s_ep0_in0_tlast}),
    .s_axis_data_tvalid ({s_ep0_in0_tvalid}),
    .s_axis_data_tready ({s_ep0_in0_tready}),
    .m_axis_data_tdata  ({m_ep0_out0_tdata}),
    .m_axis_data_tlast  ({m_ep0_out0_tlast}),
    .m_axis_data_tvalid ({m_ep0_out0_tvalid}),
    .m_axis_data_tready ({m_ep0_out0_tready}),
    .s_axis_ctrl_tdata  (s_ep0_ctrl_tdata),
    .s_axis_ctrl_tlast  (s_ep0_ctrl_tlast),
    .s_axis_ctrl_tvalid (s_ep0_ctrl_tvalid),
    .s_axis_ctrl_tready (s_ep0_ctrl_tready),
    .m_axis_ctrl_tdata  (m_ep0_ctrl_tdata),
    .m_axis_ctrl_tlast  (m_ep0_ctrl_tlast),
    .m_axis_ctrl_tvalid (m_ep0_ctrl_tvalid),
    .m_axis_ctrl_tready (m_ep0_ctrl_tready),
    .strm_seq_err_stb   (),
    .strm_data_err_stb  (),
    .strm_route_err_stb (),
    .signal_data_err    (1'b0)
  );

  // If requested buffer size is 0, use the minimum SRL-based FIFO size.
  // Otherwise, make sure it's at least two MTU-sized packets.
  localparam REQ_BUFF_SIZE_EP1 = 16384;
  localparam INGRESS_BUFF_SIZE_EP1 =
    REQ_BUFF_SIZE_EP1 == 0             ? 5         :
    REQ_BUFF_SIZE_EP1 < 2*(2**EP1_MTU) ? EP1_MTU+1 :
                                         $clog2(REQ_BUFF_SIZE_EP1);

  wire [BLOCK_CHDR_W-1:0] m_ep1_out0_tdata;
  wire                    m_ep1_out0_tlast;
  wire                    m_ep1_out0_tvalid;
  wire                    m_ep1_out0_tready;
  wire [BLOCK_CHDR_W-1:0] s_ep1_in0_tdata;
  wire                    s_ep1_in0_tlast;
  wire                    s_ep1_in0_tvalid;
  wire                    s_ep1_in0_tready;
  wire [            31:0] m_ep1_ctrl_tdata,  s_ep1_ctrl_tdata;
  wire                    m_ep1_ctrl_tlast,  s_ep1_ctrl_tlast;
  wire                    m_ep1_ctrl_tvalid, s_ep1_ctrl_tvalid;
  wire                    m_ep1_ctrl_tready, s_ep1_ctrl_tready;

  chdr_stream_endpoint #(
    .DEVICE_FAMILY      ("7SERIES"),
    .PROTOVER           (PROTOVER),
    .CHDR_W             (EP1_W),
    .BLOCK_CHDR_W       (BLOCK_CHDR_W),
    .AXIS_CTRL_EN       (0),
    .AXIS_DATA_EN       (1),
    .NUM_DATA_I         (1),
    .NUM_DATA_O         (1),
    .INST_NUM           (1),
    .CTRL_XBAR_PORT     (2),
    .INGRESS_BUFF_SIZE  (INGRESS_BUFF_SIZE_EP1),
    .MTU                (EP1_MTU),
    .REPORT_STRM_ERRS   (1)
  ) ep1_i (
    .rfnoc_chdr_clk     (rfnoc_chdr_clk),
    .rfnoc_chdr_rst     (rfnoc_chdr_rst),
    .rfnoc_ctrl_clk     (rfnoc_ctrl_clk),
    .rfnoc_ctrl_rst     (rfnoc_ctrl_rst),
    .device_id          (device_id),
    .s_axis_chdr_tdata  (xb_to_ep1_tdata),
    .s_axis_chdr_tlast  (xb_to_ep1_tlast),
    .s_axis_chdr_tvalid (xb_to_ep1_tvalid),
    .s_axis_chdr_tready (xb_to_ep1_tready),
    .m_axis_chdr_tdata  (ep1_to_xb_tdata),
    .m_axis_chdr_tlast  (ep1_to_xb_tlast),
    .m_axis_chdr_tvalid (ep1_to_xb_tvalid),
    .m_axis_chdr_tready (ep1_to_xb_tready),
    .s_axis_data_tdata  ({s_ep1_in0_tdata}),
    .s_axis_data_tlast  ({s_ep1_in0_tlast}),
    .s_axis_data_tvalid ({s_ep1_in0_tvalid}),
    .s_axis_data_tready ({s_ep1_in0_tready}),
    .m_axis_data_tdata  ({m_ep1_out0_tdata}),
    .m_axis_data_tlast  ({m_ep1_out0_tlast}),
    .m_axis_data_tvalid ({m_ep1_out0_tvalid}),
    .m_axis_data_tready ({m_ep1_out0_tready}),
    .s_axis_ctrl_tdata  (s_ep1_ctrl_tdata),
    .s_axis_ctrl_tlast  (s_ep1_ctrl_tlast),
    .s_axis_ctrl_tvalid (s_ep1_ctrl_tvalid),
    .s_axis_ctrl_tready (s_ep1_ctrl_tready),
    .m_axis_ctrl_tdata  (m_ep1_ctrl_tdata),
    .m_axis_ctrl_tlast  (m_ep1_ctrl_tlast),
    .m_axis_ctrl_tvalid (m_ep1_ctrl_tvalid),
    .m_axis_ctrl_tready (m_ep1_ctrl_tready),
    .strm_seq_err_stb   (),
    .strm_data_err_stb  (),
    .strm_route_err_stb (),
    .signal_data_err    (1'b0)
  );


  //---------------------------------------------------------------------------
  // Control Crossbar
  //---------------------------------------------------------------------------

  wire [31:0] m_core_ctrl_tdata,  s_core_ctrl_tdata;
  wire        m_core_ctrl_tlast,  s_core_ctrl_tlast;
  wire        m_core_ctrl_tvalid, s_core_ctrl_tvalid;
  wire        m_core_ctrl_tready, s_core_ctrl_tready;
  wire [31:0] m_radio0_ctrl_tdata,  s_radio0_ctrl_tdata;
  wire        m_radio0_ctrl_tlast,  s_radio0_ctrl_tlast;
  wire        m_radio0_ctrl_tvalid, s_radio0_ctrl_tvalid;
  wire        m_radio0_ctrl_tready, s_radio0_ctrl_tready;

  axis_ctrl_crossbar_nxn #(
    .WIDTH            (32),
    .NPORTS           (3),
    .TOPOLOGY         ("TORUS"),
    .INGRESS_BUFF_SIZE(5),
    .ROUTER_BUFF_SIZE (5),
    .ROUTING_ALLOC    ("WORMHOLE"),
    .SWITCH_ALLOC     ("PRIO")
  ) ctrl_xb_i (
    .clk              (rfnoc_ctrl_clk),
    .reset            (rfnoc_ctrl_rst),
    .s_axis_tdata     ({m_radio0_ctrl_tdata , m_ep0_ctrl_tdata , m_core_ctrl_tdata }),
    .s_axis_tvalid    ({m_radio0_ctrl_tvalid, m_ep0_ctrl_tvalid, m_core_ctrl_tvalid}),
    .s_axis_tlast     ({m_radio0_ctrl_tlast , m_ep0_ctrl_tlast , m_core_ctrl_tlast }),
    .s_axis_tready    ({m_radio0_ctrl_tready, m_ep0_ctrl_tready, m_core_ctrl_tready}),
    .m_axis_tdata     ({s_radio0_ctrl_tdata , s_ep0_ctrl_tdata , s_core_ctrl_tdata }),
    .m_axis_tvalid    ({s_radio0_ctrl_tvalid, s_ep0_ctrl_tvalid, s_core_ctrl_tvalid}),
    .m_axis_tlast     ({s_radio0_ctrl_tlast , s_ep0_ctrl_tlast , s_core_ctrl_tlast }),
    .m_axis_tready    ({s_radio0_ctrl_tready, s_ep0_ctrl_tready, s_core_ctrl_tready}),
    .deadlock_detected()
  );


  //---------------------------------------------------------------------------
  // RFNoC Core Kernel
  //---------------------------------------------------------------------------

  wire [(512*1)-1:0] rfnoc_core_config, rfnoc_core_status;

  rfnoc_core_kernel #(
    .PROTOVER            (PROTOVER),
    .DEVICE_TYPE         (16'hE310),
    .DEVICE_FAMILY       ("7SERIES"),
    .SAFE_START_CLKS     (0),
    .NUM_BLOCKS          (1),
    .NUM_STREAM_ENDPOINTS(2),
    .NUM_ENDPOINTS_CTRL  (1),
    .NUM_TRANSPORTS      (1),
    .NUM_EDGES           (4),
    .CHDR_XBAR_PRESENT   (1),
    .EDGE_TBL_FILE       (EDGE_TBL_FILE)
  ) core_kernel_i (
    .chdr_aclk          (chdr_aclk),
    .chdr_aclk_locked   (1'b1),
    .ctrl_aclk          (ctrl_aclk),
    .ctrl_aclk_locked   (1'b1),
    .core_arst          (core_arst),
    .core_chdr_clk      (rfnoc_chdr_clk),
    .core_chdr_rst      (rfnoc_chdr_rst),
    .core_ctrl_clk      (rfnoc_ctrl_clk),
    .core_ctrl_rst      (rfnoc_ctrl_rst),
    .s_axis_ctrl_tdata  (s_core_ctrl_tdata),
    .s_axis_ctrl_tlast  (s_core_ctrl_tlast),
    .s_axis_ctrl_tvalid (s_core_ctrl_tvalid),
    .s_axis_ctrl_tready (s_core_ctrl_tready),
    .m_axis_ctrl_tdata  (m_core_ctrl_tdata),
    .m_axis_ctrl_tlast  (m_core_ctrl_tlast),
    .m_axis_ctrl_tvalid (m_core_ctrl_tvalid),
    .m_axis_ctrl_tready (m_core_ctrl_tready),
    .device_id          (device_id),
    .rfnoc_core_config  (rfnoc_core_config),
    .rfnoc_core_status  (rfnoc_core_status)
  );


  //---------------------------------------------------------------------------
  // Blocks
  //---------------------------------------------------------------------------

  //-----------------------------------
  // radio0
  //-----------------------------------

  wire                    radio0_radio_clk;
  wire [BLOCK_CHDR_W-1:0] s_radio0_in_1_tdata , s_radio0_in_0_tdata ;
  wire                    s_radio0_in_1_tlast , s_radio0_in_0_tlast ;
  wire                    s_radio0_in_1_tvalid, s_radio0_in_0_tvalid;
  wire                    s_radio0_in_1_tready, s_radio0_in_0_tready;
  wire [BLOCK_CHDR_W-1:0] m_radio0_out_1_tdata , m_radio0_out_0_tdata ;
  wire                    m_radio0_out_1_tlast , m_radio0_out_0_tlast ;
  wire                    m_radio0_out_1_tvalid, m_radio0_out_0_tvalid;
  wire                    m_radio0_out_1_tready, m_radio0_out_0_tready;

  // ctrlport
  wire [   0:0] radio0_m_ctrlport_req_wr;
  wire [   0:0] radio0_m_ctrlport_req_rd;
  wire [  19:0] radio0_m_ctrlport_req_addr;
  wire [  31:0] radio0_m_ctrlport_req_data;
  wire [   3:0] radio0_m_ctrlport_req_byte_en;
  wire [   0:0] radio0_m_ctrlport_req_has_time;
  wire [  63:0] radio0_m_ctrlport_req_time;
  wire [   0:0] radio0_m_ctrlport_resp_ack;
  wire [   1:0] radio0_m_ctrlport_resp_status;
  wire [  31:0] radio0_m_ctrlport_resp_data;
  // time
  wire [  63:0] radio0_radio_time;
  // radio
  wire [ 255:0] radio0_radio_rx_data;
  wire [   7:0] radio0_radio_rx_stb;
  wire [   7:0] radio0_radio_rx_running;
  wire [ 255:0] radio0_radio_tx_data;
  wire [   7:0] radio0_radio_tx_stb;
  wire [   7:0] radio0_radio_tx_running;

  rfnoc_block_radio #(
    .THIS_PORTID         (2),
    .CHDR_W              (BLOCK_CHDR_W),
    .NUM_PORTS           (2),
    .NIPC                (1),
    .ITEM_W              (32),
    .MTU                 (BLOCK_MTU)
  ) b_radio0_0 (
    .rfnoc_chdr_clk      (rfnoc_chdr_clk),
    .rfnoc_ctrl_clk      (rfnoc_ctrl_clk),
    .radio_clk           (radio0_radio_clk),
    .rfnoc_core_config   (rfnoc_core_config[512*1-1:512*0]),
    .rfnoc_core_status   (rfnoc_core_status[512*1-1:512*0]),
    .m_ctrlport_req_wr   (radio0_m_ctrlport_req_wr),
    .m_ctrlport_req_rd   (radio0_m_ctrlport_req_rd),
    .m_ctrlport_req_addr (radio0_m_ctrlport_req_addr),
    .m_ctrlport_req_data (radio0_m_ctrlport_req_data),
    .m_ctrlport_req_byte_en(radio0_m_ctrlport_req_byte_en),
    .m_ctrlport_req_has_time(radio0_m_ctrlport_req_has_time),
    .m_ctrlport_req_time (radio0_m_ctrlport_req_time),
    .m_ctrlport_resp_ack (radio0_m_ctrlport_resp_ack),
    .m_ctrlport_resp_status(radio0_m_ctrlport_resp_status),
    .m_ctrlport_resp_data(radio0_m_ctrlport_resp_data),
    .radio_time          (radio0_radio_time),
    .radio_rx_data       (radio0_radio_rx_data),
    .radio_rx_stb        (radio0_radio_rx_stb),
    .radio_rx_running    (radio0_radio_rx_running),
    .radio_tx_data       (radio0_radio_tx_data),
    .radio_tx_stb        (radio0_radio_tx_stb),
    .radio_tx_running    (radio0_radio_tx_running),
    .s_rfnoc_chdr_tdata  ({s_radio0_in_1_tdata , s_radio0_in_0_tdata }),
    .s_rfnoc_chdr_tlast  ({s_radio0_in_1_tlast , s_radio0_in_0_tlast }),
    .s_rfnoc_chdr_tvalid ({s_radio0_in_1_tvalid, s_radio0_in_0_tvalid}),
    .s_rfnoc_chdr_tready ({s_radio0_in_1_tready, s_radio0_in_0_tready}),
    .m_rfnoc_chdr_tdata  ({m_radio0_out_1_tdata , m_radio0_out_0_tdata }),
    .m_rfnoc_chdr_tlast  ({m_radio0_out_1_tlast , m_radio0_out_0_tlast }),
    .m_rfnoc_chdr_tvalid ({m_radio0_out_1_tvalid, m_radio0_out_0_tvalid}),
    .m_rfnoc_chdr_tready ({m_radio0_out_1_tready, m_radio0_out_0_tready}),
    .s_rfnoc_ctrl_tdata  (s_radio0_ctrl_tdata),
    .s_rfnoc_ctrl_tlast  (s_radio0_ctrl_tlast),
    .s_rfnoc_ctrl_tvalid (s_radio0_ctrl_tvalid),
    .s_rfnoc_ctrl_tready (s_radio0_ctrl_tready),
    .m_rfnoc_ctrl_tdata  (m_radio0_ctrl_tdata),
    .m_rfnoc_ctrl_tlast  (m_radio0_ctrl_tlast),
    .m_rfnoc_ctrl_tvalid (m_radio0_ctrl_tvalid),
    .m_rfnoc_ctrl_tready (m_radio0_ctrl_tready)
  );

  //---------------------------------------------------------------------------
  // Static Router
  //---------------------------------------------------------------------------

  assign s_radio0_in_0_tdata = m_ep0_out0_tdata;
  assign s_radio0_in_0_tlast = m_ep0_out0_tlast;
  assign s_radio0_in_0_tvalid = m_ep0_out0_tvalid;
  assign m_ep0_out0_tready = s_radio0_in_0_tready;

  assign s_ep0_in0_tdata = m_radio0_out_0_tdata;
  assign s_ep0_in0_tlast = m_radio0_out_0_tlast;
  assign s_ep0_in0_tvalid = m_radio0_out_0_tvalid;
  assign m_radio0_out_0_tready = s_ep0_in0_tready;

  assign s_radio0_in_1_tdata = m_ep1_out0_tdata;
  assign s_radio0_in_1_tlast = m_ep1_out0_tlast;
  assign s_radio0_in_1_tvalid = m_ep1_out0_tvalid;
  assign m_ep1_out0_tready = s_radio0_in_1_tready;

  assign s_ep1_in0_tdata = m_radio0_out_1_tdata;
  assign s_ep1_in0_tlast = m_radio0_out_1_tlast;
  assign s_ep1_in0_tvalid = m_radio0_out_1_tvalid;
  assign m_radio0_out_1_tready = s_ep1_in0_tready;


  //---------------------------------------------------------------------------
  // Unused Ports
  //---------------------------------------------------------------------------



  //---------------------------------------------------------------------------
  // Clock Domains
  //---------------------------------------------------------------------------

  assign radio0_radio_clk = radio_clk;


  //---------------------------------------------------------------------------
  // IO Port Connection
  //---------------------------------------------------------------------------

  // Master/Slave Connections:
  assign m_ctrlport_req_wr = radio0_m_ctrlport_req_wr;
  assign m_ctrlport_req_rd = radio0_m_ctrlport_req_rd;
  assign m_ctrlport_req_addr = radio0_m_ctrlport_req_addr;
  assign m_ctrlport_req_data = radio0_m_ctrlport_req_data;
  assign m_ctrlport_req_byte_en = radio0_m_ctrlport_req_byte_en;
  assign m_ctrlport_req_has_time = radio0_m_ctrlport_req_has_time;
  assign m_ctrlport_req_time = radio0_m_ctrlport_req_time;
  assign radio0_m_ctrlport_resp_ack = m_ctrlport_resp_ack;
  assign radio0_m_ctrlport_resp_status = m_ctrlport_resp_status;
  assign radio0_m_ctrlport_resp_data = m_ctrlport_resp_data;

  assign radio0_radio_rx_data = radio_rx_data;
  assign radio0_radio_rx_stb = radio_rx_stb;
  assign radio_rx_running = radio0_radio_rx_running;
  assign radio_tx_data = radio0_radio_tx_data;
  assign radio0_radio_tx_stb = radio_tx_stb;
  assign radio_tx_running = radio0_radio_tx_running;

  // Broadcaster/Listener Connections:
  assign radio0_radio_time = radio_time;

endmodule


`default_nettype wire
